attribute vec4 a_position;
attribute vec2 a_texCoord;

uniform vec2 u_uvSize;
uniform vec2 u_uvSizeBWMask;

uniform vec2 u_uvPos;
uniform vec2 u_uvBWPos;

uniform vec4 u_vertexScale;
uniform vec4 u_vertexOffset;
uniform float u_orientation;

varying vec2 v_texCoord;
varying vec2 v_texCoordMask;
varying vec2 v_BWMaskCoord;

void main()
{
    float cosTheta = cos(u_orientation);
    float sinTheta = sin(u_orientation);
    
    vec4 scaled = a_position;
    
    scaled.x -= 0.5;
    scaled.y -= 0.5;
    scaled.x *=  u_vertexScale.x;
    scaled.y *=  u_vertexScale.y;
    vec4 oriented;
    
    oriented.x = scaled.x * cosTheta - scaled.y * sinTheta;
    oriented.y = scaled.x * sinTheta + scaled.y * cosTheta;
    oriented.zw = scaled.zw;
    
    oriented.x += 0.5 * u_vertexScale.x;
    oriented.y += 0.5 * u_vertexScale.y;
    
    gl_Position = CC_MVPMatrix * (oriented + u_vertexOffset);
    v_texCoord = a_texCoord * u_uvSize + u_uvPos;
    v_BWMaskCoord = a_texCoord;
}

